//=============================================================================
// HzMoreCharaSpriteControll.js
//=============================================================================

/*:ja
 * @plugindesc キャラクタの拡大縮小・回転機能を追加します
 * @author hiz
 *
 *  @help 
 *  
 * プラグイン コマンド:
 *   HzRotate  eventId angle                  # イベントの角度をangle度に設定(default:0)
 *   HzScale   eventId scaleX scaleY          # イベントの各縮率を(scaleX, scaleY)に設定(default:(1,1))
 *   HzAnchor  eventId anchorX anchorY        # イベントの中心点を(anchorX, anchorY)に設定(default:(0.5,0.5))
 *   
 *  event = 0 →このイベント
 *  event = -1 →プレイヤー
 *  event = -2・-3・-4 ⇒フォロワー一人目・二人目・三人目
 */
/*:en
 * @plugindesc Add scaling/rotating to characters.
 * @author hiz
 *
 *  @help 
 *  
 * プラグイン コマンド:
 *   HzRotate  eventId angle                  # Set an event angle.(default:0)
 *   HzScale   eventId scaleX scaleY          # Set an event scale.(default:(1,1))
 *   HzAnchor  eventId anchorX anchorY        # Set an event anchor.(default:(0.5,0.5))
 *   
 *  event = 0  -> this event
 *  event = -1 -> player
 *  event = -2/-3/-4 -> follower1/2/3
 */

(function() {
    
    function convertEscape(txt) {return Window_Base.prototype.convertEscapeCharacters(txt)};
    
    var _Game_Interpreter_pluginCommand =
            Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command.toUpperCase() === 'HZROTATE') {
            var eventId = Number(convertEscape(args[0]));
            if(eventId >= 0) {
                // イベント
                if(eventId === 0) eventId = this._eventId;
                $gameMap.event(eventId)._angle = Number(convertEscape(args[1]));
            } else if(eventId === -1) {
                // プレイヤー
                $gamePlayer._angle = Number(convertEscape(args[1]));
            } else {
                // フォロワー
                $gamePlayer.followers().follower(-(eventId+2))._angle = Number(convertEscape(args[1]));
            }
        } else if (command.toUpperCase() === 'HZSCALE') {
            var eventId = Number(convertEscape(args[0]));
            if(eventId >= 0) {
                // イベント
                if(eventId === 0) eventId = this._eventId;
                $gameMap.event(eventId)._scale.x = Number(convertEscape(args[1]));
                $gameMap.event(eventId)._scale.y = Number(convertEscape(args[2]));
            } else if(eventId === -1) {
                // プレイヤー
                $gamePlayer._scale.x = Number(convertEscape(args[1]));
                $gamePlayer._scale.y = Number(convertEscape(args[2]));
            } else {
                // フォロワー
                $gamePlayer.followers().follower(-(eventId+2))._scale.x = Number(convertEscape(args[1]));
                $gamePlayer.followers().follower(-(eventId+2))._scale.y = Number(convertEscape(args[2]));
            }
        } else if (command.toUpperCase() === 'HZANCHOR') {
            var eventId = Number(convertEscape(args[0]));
            if(eventId >= 0) {
                // イベント
                if(eventId === 0) eventId = this._eventId;
                $gameMap.event(eventId)._anchor.x = Number(convertEscape(args[1]));
                $gameMap.event(eventId)._anchor.y = Number(convertEscape(args[2]));
            } else if(eventId === -1) {
                // プレイヤー
                $gamePlayer._anchor.x = Number(convertEscape(args[1]));
                $gamePlayer._anchor.y = Number(convertEscape(args[2]));
            } else {
                // フォロワー
                $gamePlayer.followers().follower(-(eventId+2))._anchor.x = Number(convertEscape(args[1]));
                $gamePlayer.followers().follower(-(eventId+2))._anchor.y = Number(convertEscape(args[2]));
            }
        }
    };

    var _Sprite_Character_updateOther = Sprite_Character.prototype.updateOther;
    Sprite_Character.prototype.updateOther = function() {
        _Sprite_Character_updateOther.call(this);
        this.rotation = this._character.angle() * Math.PI / 180;
        this.scale    = this._character.scale();
        this.anchor   = this._character.anchor();
    };
    
    var _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function() {
        _Game_CharacterBase_initMembers.call(this);
        this._angle  = 0;
        this._scale  = new Point(1.0, 1.0);
        this._anchor = new Point(0.5, 1.0);
    };
    
    // イベントの角度を取得
    Game_CharacterBase.prototype.angle = function() {
        return this._angle;
    };
    
    // イベントの角度を設定
    Game_CharacterBase.prototype.setAngle = function(angle) {
        this._angle = angle;
    };
    
    // イベントの拡縮率を取得
    Game_CharacterBase.prototype.scale = function() {
        return this._scale;
    };
    
    // イベントの拡縮率を設定
    Game_CharacterBase.prototype.setScale = function(scaleX, scaleY) {
        this._scale.x = scaleX;
        this._scale.y = scaleY;
    };
    
    // イベントの中心点を取得
    Game_CharacterBase.prototype.anchor = function() {
        return this._anchor;
    };
    
    // イベントの中心点を設定
    Game_CharacterBase.prototype.setAnchor = function(anchorX, anchorY) {
        this._anchor.x = anchorX;
        this._anchor.y = anchorY;
    };
})();