/*:
 * @plugindesc モンプチ用
 * @author 夕多丸
 **/

class Monpuchi {
  constructor() {
    this.inuSt = {
      turn: 0,
      actions: [
        ["move", 12, 4],
        ["move", 19, 4],
        ["move", 18, 9],
        ["move", 12, 9],
        //
        ["move", 12, 4],
        ["move", 18, 4],
        ["move", 17, 4],
        ["move", 18, 4],
        ["move", 19, 9],
        ["move", 12, 9],
        ["move", 14, 9],
        ["move", 12, 9],

        ["move", 18, 9],
        ["move", 19, 4],
        ["move", 12, 4],
        ["move", 12, 6],
        //["wait", 4, 8],
      ],
      detour: false,
      wait: 0
    }
    this.goCutPosition = [];
  }

  showGoCutPicture() {
    const vpos = this.goCutPosition[0];
    $gameScreen.showPicture(32, this.goCutPicture, 1, vpos.x, vpos.y, 300, 300, 0, 0);
    $gameScreen.showPicture(33, this.goCutPicture + "_tx", 1, 408, 520, 100, 1, 0, 0);
  }

  setGoCutPosition(name, prm) {
    this.goCutPicture = "gameover:" + name;
    this.goCutPosition = prm;
  }

  playGoCutPosition(num, wait) {
    const vpos = this.goCutPosition[num];
    const vopa = (wait === 1) ? 255 : 0;
    $gameScreen.movePicture(32, 1, vpos.x, vpos.y, 300, 300, vopa, 0, wait);
  }

  inuMovePattern(event) {
    let tp = this.inuSt.actions[this.inuSt.turn];
    switch (tp[0]) {
      case "move":
        let to = 2; // 移動方向
        let toX = 0;
        let toY = 0;
        //
        if (tp[1] !== event._x) toX = (event._x < tp[1]) ? 1 : -1;
        if (tp[2] !== event._y) toY = (event._y < tp[2]) ? 1 : -1;
        // 移動先が壁
        if (($gameMap.regionId(event.x + toX, event.y) === 2) === true) toX = 0;
        if (($gameMap.regionId(event.x, event.y + toY) === 2) === true) toY = 0;
        //
        if (toX !== 0 && toY !== 0) {
          if (Math.random() * 10 > 5) {
            toX = 0;
          } else {
            toY = 0;
          }
        }
        if (toX > 0) to = 6;
        if (toX < 0) to = 4;
        if (toY > 0) to = 2;
        if (toY < 0) to = 8;
        //
        event._direction = to;
        //
        // 目的地に党略
        if (tp[1] === event.x + toX && tp[2] === event.y + toY) {
          this.inuSt.turn++;
          if (this.inuSt.turn > this.inuSt.actions.length - 1) this.inuSt.turn = 0;
        }
        break;
    }
  }

  inu(id, option) {
    const areaX = [option.x1, option.x2];
    const areaY = [option.y1, option.y2];
    const inu = $gameMap.events().find(q => q._eventId === id);
    const pl = $gamePlayer;
    let isArea = false;
    let isFind = false;
    if (pl.x >= areaX[0] && pl.x <= areaX[1]) {
      if (pl.y >= areaY[0] && pl.y <= areaY[1]) {
        isArea = true;
      }
    }
    if (Math.abs(pl.y - inu.y) <= option.w) {
      if (inu._direction === 6 && pl.x > inu.x) isFind = true; // 右
      if (inu._direction === 4 && pl.x < inu.x) isFind = true; // 左
    }
    if (Math.abs(pl.x - inu.x) <= option.w) {
      if (inu._direction === 2 && pl.y > inu.y) isFind = true; // 下
      if (inu._direction === 8 && pl.y < inu.y) isFind = true; // 上
    }
    $gameSwitches.setValue(option.sw1, isArea);
    $gameSwitches.setValue(option.sw2, isFind);
  };

  piero(option) {
    const areaX = [option.x1, option.x2];
    const areaY = [option.y1, option.y2];
    const pl = $gamePlayer;
    let isArea = false;
    let isFind = false;
    if (pl.x >= areaX[0] && pl.x <= areaX[1]) {
      if (pl.y >= areaY[0] && pl.y <= areaY[1]) {
        isArea = true;
      }
    }
    if (isArea === true) {
      const vx = Math.abs($gameVariables.value(option.plX) - pl.x);
      const vy = Math.abs($gameVariables.value(option.plY) - pl.y);
      if (vx + vy > 0) isFind = true;
    }
    //console.log(isArea, isFind, $gameVariables.value(option.plX), pl.x, $gameVariables.value(option.plY), pl.y);
    $gameVariables.setValue(option.plX, pl.x);
    $gameVariables.setValue(option.plY, pl.y);
    $gameSwitches.setValue(option.sw1, isArea);
    $gameSwitches.setValue(option.sw2, isFind);
  }

  isHakoFacingWall(id) {
    const pl = $gamePlayer;
    const tg = $gameMap.event(id);
    const vx = tg.x - (pl.x - tg.x);
    const vy = tg.y - (pl.y - tg.y);
    const region = ($gameMap.regionId(vx, vy) !== 1);
    if (region === true) {
      const ev = $gameMap.eventIdXy(vx, vy);
      if (ev === 0) {
        return true;
      } else {
        return ($gameMap.event(ev)._priorityType !== 1);
      }
    } else {
      return false;
    }
  }

  slimeDownSize(char, sizeId) {
    const num = $gameVariables.value(sizeId);
    $gameVariables.setValue(sizeId, num - 1);
    const args = [
      String(char),
      String(num / 10),
      String(num / 10)
    ];
    Game_Interpreter.prototype.pluginCommand("HzScale", args);
  }

  slimeCollide(char, sizeId, collideId, winId) {
    const num = $gameVariables.value(sizeId);
    const pl = $gamePlayer;
    const tg = $gameMap.event(char);
    if (pl.x === tg.x && pl.y === tg.y) {
      $gameSwitches.setValue(collideId, true);
    }
    if (num < 10) {
      $gameSwitches.setValue(winId, true);
      const args = [String(char), "1", "1"];
      Game_Interpreter.prototype.pluginCommand("HzScale", args);
    }
  }

  setCharToujouAnimation(vname) {
    const getSprite = (vn, vname, vorg, vx, vy, vw, vh, vo) => {
      $gameScreen.showPicture(vn, vname, vorg, vx, vy, vw, vh, vo, 0);
      return $gameScreen.picture(vn);
    }
    // 背景画像
    getSprite(30, vname + "_toujyou_bg", 0, 0, 0, 100, 100, 0)._keyFrames = [
      { opacity: 155, d: 30 }
    ];
    getSprite(31, vname + "_toujyou_bar1", 1, 408, 312, 100, 1, 0)._keyFrames = [
      { d: 10 }, { d: 0, opacity: 255 }, { d: 10, scaleY: 100 }
    ];
    getSprite(32, vname + "_toujyou_bar2", 1, 408, 312, 100, 100, 0)._keyFrames = [
      { d: 80 }, { d: 30, opacity: 255 }
    ];
    getSprite(33, vname + "_toujyou_char", 1, 240, 624 + 312, 110, 110, 255)._keyFrames = [
      { d: 0 }, { d: 20, y: 312 - 30 }, { d: 6, y: 312 }, { d: 500, scale: 100 },
    ];
    getSprite(34, vname + "_toujyou_name", 1, 408, 714, 100, 100, 255)._keyFrames = [
      { d: 30 }, { d: 16, y: 494 }, { d: 8, y: 524 }, { d: 4, y: 514 }
    ];
    getSprite(35, vname + "_toujyou_text", 0, -816, 240, 100, 100, 255)._keyFrames = [
      { d: 20 }, { d: 10, x: 16, y: -4 }, { d: 5, x: 0, y: 0 }
    ];
    getSprite(37, vname + "_toujyou_graph3", 1, 338 + 240, 40 + 240, 150, 150, 0)._keyFrames = [
      { d: 100 }, { d: 20, scale: 100, opacity: 255 }
    ];
    getSprite(38, vname + "_toujyou_graph2", 1, 338 + 240, 40 + 240, 1, 1, 0)._keyFrames = [
      { d: 110 }, { d: 20, scale: 110, opacity: 255 }, { d: 5, scale: 100 }
    ];
    getSprite(39, vname + "_toujyou_graph1", 1, 338 + 240, 40 + 240, 100, 100, 0)._keyFrames = [
      { d: 100 }, { d: 50, opacity: 255 }
    ];
  }

  endCharToujouAnimation() {
    const setSpriteKeyframe = (vn, vk) => {
      $gameScreen.picture(vn)._keyFrames = vk;
      $gameScreen.picture(vn)._keyPosition = 0;
      $gameScreen.picture(vn)._keyDuration = 0;
    }
    setSpriteKeyframe(30,  [
      { d: 10 }, { opacity: 0, d: 30 }
    ]);
    setSpriteKeyframe(31, [
      { d: 10 }, { d: 0, opacity: 0 }
    ]);
    setSpriteKeyframe(32, [
      { d: 15 }, { d: 20, scaleY: 1, opacity: 0 }
    ]);
    setSpriteKeyframe(33, [
      { d: 10 }, { d: 10, opacity: 0 }
    ]);
    setSpriteKeyframe(34,  [
        { d: 10 }, { d: 10, y: 494 }, { d: 5, y: 714 }
    ]);
    setSpriteKeyframe(35,  [
      { d: 5, x: -16, y: 4 }, { d: 10, x: 816, y: -260 }
    ]);
    setSpriteKeyframe(37, [
      { d: 10 }, { d: 10, scale: 10, opacity: 0 }
    ]);
    setSpriteKeyframe(38, [
      { d: 10 }, { d: 10, scale: 10, opacity: 0 }
    ]);
    setSpriteKeyframe(39, [
      { d: 10 }, { d: 10, scale: 10, opacity: 0 }
    ]);
  }
}

var monpuchi = new Monpuchi();

(function () {
  // セーブ・ロード画面カスタマイズ

  DataManager.maxSavefiles = function () {
    return 4;
  };

  Window_SavefileList.prototype.maxVisibleItems = function () {
    return 4;
  };

  Window_SavefileList.prototype.drawItem = function (index) {
    var id = index + 1;
    var valid = DataManager.isThisGameFile(id);
    var info = DataManager.loadSavefileInfo(id);
    var rect = this.itemRectForText(index);
    this.resetTextColor();
    if (this._mode === 'load') {
      this.changePaintOpacity(valid);
    }
    this.drawFileId(id, rect.x, rect.y);
    if (info) {
      this.changePaintOpacity(valid);
      this.drawContents(info, rect, valid);
      this.changePaintOpacity(true);

    }
  };

  Window_SavefileList.prototype.drawFileId = function (id, x, y) {
    if (id === 4) {
      this.drawText('オートセーブ', x, y, 180);
    } else {
      this.drawText('脳みそ ' + id, x, y, 180);
    }
  };

  // セーブ・ロード画面のタイトル表示をラベルに変更
  Window_SavefileList.prototype.drawGameTitle = function (info, x, y, width) {
    if (info.title) {
      this.drawText(info.label, x, y, width);
    }
  };

  // (624 - 460 - 72) / 2 = 46

  Scene_File.prototype.createHelpWindow = function () {
    this._helpWindow = new Window_Help(1);
    this._helpWindow.x = (816 - 460) / 2;
    this._helpWindow.y = 46;
    this._helpWindow.width = 460;
    this._helpWindow.setText(this.helpWindowText());
    this.addWindow(this._helpWindow);
  };

  Scene_Save.prototype.helpWindowText = function () {
    return TextManager.saveMessage;
  };

  Scene_Load.prototype.helpWindowText = function () {
    return TextManager.loadMessage;
  };

  Scene_File.prototype.createListWindow = function () {
    var x = (816 - 460) / 2;
    var y = 46 + 72;
    this._listWindow = new Window_SavefileList(x, y, 460, 460);
    this._listWindow.setHandler('ok', this.onSavefileOk.bind(this));
    this._listWindow.setHandler('cancel', this.popScene.bind(this));
    this._listWindow.select(this.firstSavefileIndex());
    this._listWindow.setTopRow(this.firstSavefileIndex() - 2);
    this._listWindow.setMode(this.mode());
    this._listWindow.refresh();
    this.addWindow(this._listWindow);
  };

  Window_SavefileList.prototype.drawContents = function (info, rect, valid) {
    var bottom = rect.y + rect.height;
    if (rect.width >= 320) { // 420
      if (rect.y > 300) info.title = "";
      this.drawGameTitle(info, rect.x + 192, rect.y, rect.width - 192);
      if (valid) {
        this.drawPartyCharacters(info, rect.x + 220, bottom - 4);
      }
    }
    var lineHeight = this.lineHeight();
    var y2 = bottom - lineHeight;
    if (y2 >= lineHeight) {
      this.drawPlaytime(info, rect.x, y2, rect.width);
    }
  };


  Window_SavefileList.prototype.drawPartyCharacters = function (info, x, y) {
    if (info.characters) {
      for (var i = 0; i < info.characters.length; i++) {
        var data = info.characters[i];
        this.drawCharacter(data[0], data[1], 172, y);
      }
    }
  };

  DataManager.makeSavefileInfo = function () {
    var info = {};
    info.globalId = this._globalId;
    info.title = $dataSystem.gameTitle;
    info.label = $gameVariables.value(1); // 場所を格納
    info.characters = $gameParty.charactersForSavefile();
    info.faces = $gameParty.facesForSavefile();
    info.playtime = $gameSystem.playtimeText();
    info.timestamp = Date.now();
    return info;
  };

  Scene_Gameover.prototype.create = function () {
    Scene_Base.prototype.create.call(this);
    this.playGameoverMusic();
    // this.createBackground();
  };

  Scene_Gameover.prototype.start = function () {
    Game_Interpreter.prototype.pluginCommand("SaveCommand", ["load", "4"]);
    Scene_Base.prototype.start.call(this);
    this.startFadeIn(this.slowFadeSpeed(), false);
  };

  var loadingWait = 0;
  // ローディング
  Graphics._paintUpperCanvas = function () { // 82
    this._clearUpperCanvas();
    if (this._loadingImage && this._loadingCount >= 20) {
      loadingWait = (loadingWait >= 29) ? 0 : loadingWait + 1;
      const vc = Math.floor(loadingWait / 10)
      var context = this._upperCanvas.getContext('2d');
      var dx = (this._width - this._loadingImage.width) / 2;
      var dy = (this._height - this._loadingImage.height / 3) / 2;
      var alpha = ((this._loadingCount - 20) / 30).clamp(0, 1);
      context.save();
      context.globalAlpha = alpha;
      context.drawImage(this._loadingImage, 0, vc * 82, 368, 82, dx, dy, 368, 82);
      context.restore();
    }
  };

  Scene_Item.prototype.createItemWindow = function () {
    const vw = 816 - 300;
    var wy = this._categoryWindow.y + this._categoryWindow.height;
    //var wh = Graphics.boxHeight - wy;
    // Graphics.boxWidth
    this._itemWindow = new Window_ItemList(150, wy, vw, 340);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler('ok', this.onItemOk.bind(this));
    this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
    this.addWindow(this._itemWindow);
    this._categoryWindow.setItemWindow(this._itemWindow);
    //
    this._helpWindow.width = vw;
    this._helpWindow.x = 150;
    this._helpWindow.y = 76;
    this.hideSubWindow(this._categoryWindow);
    setTimeout(() => {
      this._itemWindow.selectLast();
    }, 100);
  };

  Scene_Item.prototype.onItemCancel = function () {
    this._itemWindow.deselect();
    this.popScene();
  };

  Window_ItemList.prototype.maxCols = function () {
    return 1;
  };

  Window_MenuCommand.prototype.makeCommandList = function () {
    //this.addTorigoyaCommands();
    this.addMainCommands();
    //this.addTorigoyaAchievementCommands();
    //this.addFormationCommand();
    //this.addOriginalCommands();
    this.addOptionsCommand();
    this.addSaveCommand();
    this.addGameEndCommand();
  };

  Window_MenuCommand.prototype.addTorigoyaAchievementCommands = function () {
    this.addCommand(Torigoya.Achievement2.parameter.titleMenuText, 'Torigoya_Achievement', true);
  };

  Window_MenuCommand.prototype.addTorigoyaCommands = function () {
    Torigoya.CommonMenu.parameter.baseItems.forEach((item, i) => {
      const enabled = item.switchId ? $gameSwitches.value(parseInt(item.switchId, 10)) : true;
      if (!enabled && !item.visibility) return;
      this.addCommand(item.name, 'TorigoyaCommonMenu_'.concat(i), enabled);
    });
  };
})();

// タイトル改造
Scene_Title.prototype.start = function () {
  this.version = "demo1"; // 体験版
  // this.version = "main1"; // 完成版
  //
  if (this.version === "demo1") { // 体験版のタイトル
    this.animeSt = {
      logo: this.animeGetSprite("Title_demo1_logo", 0, 0),
      monpuchi: this.animeGetSprite("Title_demo1_monpuchi", 0, 0),
      front: this.animeGetSprite("Title_demo1_front", 0, 0),
      count: 0
    }
    // タイトルウィンドウの位置を指定
    this._commandWindow.x = 480;
    this._commandWindow.y = 196;
    this._commandWindow.setBackgroundType(2);
  }
  if (this.version === "main1") { // 完成版のタイトル
    this.animeSt = {
      akari1: this.animeGetSprite("Title_main1_akari1", 0, 0),
      akari2: this.animeGetSprite("Title_main1_akari2", 0, 0),
      noumiso: this.animeGetSprite("Title_main1_mon", 432, 7 - 20),
      kumo: this.animeGetSprite("Title_main1_kumo", 385, 280 - 54),
      logo: this.animeGetSprite("Title_main1_logo", 48, 123),
      count: 0
    }
    // タイトルウィンドウの位置を指定
    this._commandWindow.x = 320;
    this._commandWindow.y = 390;
    this._commandWindow.setBackgroundType(2);
  }
  //
  Scene_Base.prototype.start.call(this);
  SceneManager.clearStack();
  this.centerSprite(this._backSprite1);
  this.centerSprite(this._backSprite2);
  this.playTitleMusic();
  this.startFadeIn(this.fadeSpeed(), false);
};

Scene_Title.prototype.update = function () {
  if (this.version === "demo1") { // 体験版のタイトル
    this.animeSt.count++;
    if (this.animeSt.count < 155) {
      this.animeSt.logo.opacity = this.animeSt.count + 100;
    }
    this.animeSt.front.y = Math.sin(this.animeSt.count / 48) * 10 - 5;
    this.animeSt.monpuchi.y = Math.sin(this.animeSt.count / 48) * 10 - 5;
    //
    const vstep = this.animeSt.count % 300;
    if (vstep > 160 && vstep < 200) {
      const vx = (vstep - 160) % 20;
      if (vx < 10) {
        this.animeSt.monpuchi.x = vx * -1;
      } else {
        this.animeSt.monpuchi.x = (20 - vx) * -1;
      }
    }
  }
  if (this.version === "main1") { // 完成版のタイトル
    this.animeSt.count++;
    this.animeSt.noumiso.y = Math.floor((this.animeSt.noumiso.defaultY + Math.sin(this.animeSt.count / 60) * 13) * 10) / 10;
    this.animeSt.kumo.y = Math.floor((this.animeSt.kumo.defaultY + Math.sin(this.animeSt.count / 80) * 6) * 10) / 10;
    this.animeSt.akari1.opacity = 192 + Math.sin(this.animeSt.count / 12) * 64 - 1;
    this.animeSt.akari2.opacity = 160 + Math.sin(this.animeSt.count / 15 + 50) * 96 - 1;
    if (this.animeSt.count < 255) {
      this.animeSt.logo.opacity = this.animeSt.count;
    }
  }
  //
  if (!this.isBusy()) {
    this._commandWindow.open();
  }
  Scene_Base.prototype.update.call(this);
};

Scene_Title.prototype.animeGetSprite = function (pictureName, x, y) {
  var sprite = new Sprite(ImageManager.loadTitle1(pictureName));
  sprite.x = x;
  sprite.y = y;
  sprite.defaultX = x;
  sprite.defaultY = y;
  sprite.anchor.x = 0;
  sprite.anchor.y = 0;
  this.addChild(sprite);
  return sprite;
}

// メニューの追加順序を変更
Window_Command.prototype.addCommand = function (name, symbol, enabled, ext) {
  if (enabled === undefined) enabled = true;
  if (ext === undefined) ext = null;
  //
  const vo = {
    "newGame": 0,
    "continue": 1,
    "item": 2,
    "Torigoya_Achievement": 3,
    "save": 4,
    "load": 5,
    "options": 6,
    "TorigoyaCommonMenu_0": 7,
    "gameEnd": 8,
  };
  //
  const order = (vo[symbol] === undefined) ? vo.length + 1 : vo[symbol];
  this._list.push({ name: name, symbol: symbol, enabled: enabled, ext: ext, order: order });
  this._list.sort((a, b) => a.order - b.order);
};

// メニューの表示数を設定
Window_MenuCommand.prototype.numVisibleRows = function () {
  return 5;
};

// 選択肢で未選択の場合は1つめを選択してreturn
Window_Selectable.prototype.processOk = function () {
  if (this.isCurrentItemEnabled()) {
    this.playOkSound();
    this.updateInputData();
    this.deactivate();
    this.callOkHandler();
  } else {
    if (this.index() === -1) return this.select(0);
    this.playBuzzerSound();
  }
};

ImageManager.loadPicture = function (filename, hue) {
  const vpath = filename.split(":");
  if (vpath.length < 2) {
    return this.loadBitmap('img/pictures/', filename, hue, true);
  } else {
    return this.loadBitmap('img/' + vpath[0] + "/", vpath[1], hue, true);
  }
};

// //////////////////////////////////////////////////////////////////////////////////
// 立ち絵アニメーション
// //////////////////////////////////////////////////////////////////////////////////
class CharacterAnimation {
  constructor() {
    const self = this;
    //
    // IZ_MessageWindow.jsにコードを追加
  }

  setAnimation(self, textState) {
    const vprm = textState.text.replace("\act[", "\ACT[");
    let prm = vprm.split("\ACT[")[1].split("]")[0];
    textState.text = textState.text.replace("[" + prm + "]", "");
    self.characterWait = 0;
    prm = prm.toUpperCase();
    switch (prm) {
      case 'IN': return this.actIn();
      case 'PYON': return this.actPyon();
      case 'PYON2': return this.actPyon2();
      case 'KURUN': return this.actKurun();
      case 'WAA': return this.actWaa();
      case 'PIKA': return this.actPika();
      case 'KAKURE': return this.actKakure();
      case 'CHIRA': return this.actChira();
      case 'ZOOM': return this.actZoom();
      case 'MINI': return this.actMini();
      case 'AGE': return this.actAge();
      case 'SAGE': return this.actSage();
      case 'BURU': return this.actBuru();
      case 'OJIGI': return this.actOjigi();
      case 'GAGA': return this.actGaga();
      case 'ODORU': return this.actOdoru();
      case 'YOKE': return this.actYoke();
      case 'HUTTOBI': return this.actHuttobi();
      default:
        return null;
    }
  }

  actIn() {
    const o = this.getOrigin();
    return [
      o.first,
      { y: o.y + 30, opacity: 255, d: 0 },
      { y: o.y - 5, d: 8 },
      { y: o.y, d: 4 }
    ];
  }

  actPyon() {
    AudioManager.playSe({ "name": "OtoLogic_act_pyon", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { y: o.y + 30, opacity: 255, d: 0 },
      { y: o.y, d: 16 }
    ];
  }

  actPyon2() {
    AudioManager.playSe({ "name": "OtoLogic_act_pyon2", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { y: o.y + 30, opacity: 255, d: 0 },
      { y: o.y, d: 4 }, { y: o.y + 50, d: 8 },
      { y: o.y, d: 4 }, { y: o.y + 50, d: 8 },
      { y: o.y, d: 4 }
    ];
  }

  actKurun() {
    AudioManager.playSe({ "name": "Kurage_act_kurun", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { scaleX: -100, d: 6 },
      { scaleX: 100, d: 10 },
    ];
  }

  actWaa() { // 未使用
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { scale: 120, d: 3 }, { scale: 100, d: 5 },
      { scale: 120, d: 3 }, { scale: 100, d: 5 },
      { scale: 120, d: 3 }, { scale: 100, d: 5 },
      { scale: 120, d: 3 }, { scale: 100, d: 5 },
    ];
  }

  actPika() {
    AudioManager.playSe({ "name": "OtoLogic_act_pika", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { opacity: 155, blendMode: 3, d: 15 },
      { opacity: 255, blendMode: 0, d: 25 }
    ];
  }

  actKakure() {
    AudioManager.playSe({ "name": "OtoLogic_act_kakure", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { x: o.x + 80, d: 10 },
      { x: o.x + 95, d: 5 },
      { x: o.x + 80, d: 3 }, { x: o.x + 95, d: 5 },
      { x: o.x + 80, d: 3 }, { x: o.x + 95, d: 5 }
    ];
  }

  actZoom() {
    AudioManager.playSe({ "name": "Onjin_act_up", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { scale: 145, d: 6 },
      { scale: 140, d: 10 },
    ];
  }

  actMini() {
    AudioManager.playSe({ "name": "wind1", "volume": 100, "pitch": 200, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { y: o.y + 5, d: 3 },
      { y: o.y, d: 3 },
      { x: o.x + 45, y: o.y + 65, scale: 78, d: 10 },
      { scale: 80, d: 10 }
    ];
  }

  actAge() {
    AudioManager.playSe({ "name": "Onjin_act_age", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { y: o.y + 624, scale: 90, opacity: 255, d: 0 },
      { y: o.y, scale: 100, d: 25 },
      { y: o.y + 10, d: 5 },
      { y: o.y, d: 5 }
    ];
  }

  actSage() {
    AudioManager.playSe({ "name": "Onjin_act_sage", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { y: o.y, scale: 100, opacity: 255, d: 0 },
      { y: o.y + 624, scale: 90, d: 70 }
    ];
  }

  actBuru() {
    AudioManager.playSe({ "name": "OtoLogic_act_buru", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { x: o.x - 15, d: 3 }, { x: o.x + 15, d: 3 },
      { x: o.x - 15, d: 3 }, { x: o.x + 15, d: 3 },
      { x: o.x - 15, d: 3 }, { x: o.x + 15, d: 3 },
      { x: o.x - 15, d: 3 }, { x: o.x, d: 3 },
    ];
  }

  actOjigi() {
    AudioManager.playSe({ "name": "OtoLogic_act_ojigi", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { y: o.y + 60, scaleY: 80, d: 8 },
      { y: o.y, scaleY: 100, d: 15 }
    ];
  }

  actGaga() {
    AudioManager.playSe({ "name": "OtoLogic_act_gaga", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { x: o.x - 20, scale: 110, d: 0 }, { blendMode: 0, d: 3 },
      { x: o.x + 20, scale: 100, d: 0 }, { blendMode: 3, d: 3 },
      { x: o.x - 20, scale: 110, d: 0 }, { blendMode: 3, d: 3 },
      { x: o.x + 20, scale: 100, blendMode: 0, d: 0 }, { d: 3 },
      { x: o.x - 20, scale: 110, d: 0 }, { d: 3 },
      { x: o.x + 20, scale: 100, d: 0 }, { d: 3 },
      { x: o.x - 20, scale: 110, d: 0 }, { d: 3 },
      { x: o.x + 20, scale: 100, d: 0 }, { d: 3 },
    ];
  }

  actOdoru() {
    AudioManager.playSe({ "name": "OtoLogic_act_odoru", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, d: 0 },
      { scale: 100, x: o.x - 30, angle: -7, d: 0 },
      { scale: 112, d: 20 },
      { scale: 100, x: o.x + 30, angle: 7, d: 0 },
      { scale: 112, d: 20 },
      { scale: 100, x: o.x, angle: 0, d: 0 },
      { scale: 105, d: 5 },
      { scale: 100, d: 5 },
    ];
  }

  actYoke() {
    AudioManager.playSe({ "name": "Onjin_act_yoke", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { opacity: 255, y: o.y + 20, d: 0 },
      { x: o.x + 100, angle: 10, d: 7 },
      { x: o.x - 100, angle: -10, d: 7 },
      { x: o.x + 100, angle: 10, d: 7 },
      { x: o.x - 100, angle: -10, d: 7 },
      { x: o.x, y: o.y, angle: 0, d: 10 },
    ];
  }

  actHuttobi() {
    AudioManager.playSe({ "name": "OtoLogic_act_huttobi", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { rotationSpeed: 14, opacity: 255, d: 0 },
      { x: o.x + 30, d: 10, },
      { rotationSpeed: 17, d: 0 },
      { x: o.x + 50, scale: 95, d: 10, },
      { rotationSpeed: 20, d: 0 },
      { x: o.x + 500, scale: 95, d: 50, },
      { opacity: 0, d: 10 },
    ];
  }

  actChira() {
    AudioManager.playSe({ "name": "OtoLogic_act_tira", "volume": 100, "pitch": 100, "pan": 0 }); // 効果音を鳴らす
    const o = this.getOrigin();
    return [
      o.first,
      { x: o.x + 815, angle: -20, d: 0, opacity: 255 },
      { x: o.x + 80, d: 30 },
      { x: o.x + 95, d: 5 },
    ];
  }

  getOrigin() {
    return {
      first: { origin: 1, x: 383 + (432 / 2), y: 0 + (624 / 2), d: 0 },
      x: 383 + (432 / 2),
      y: 0 + (624 / 2),
    }
  }
}

var characterAnimation = new CharacterAnimation();

// //////////////////////////////////////////////////////////////////////////////////
// 吹き出し拡張
// //////////////////////////////////////////////////////////////////////////////////
const _pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function (command, args) {
  _pluginCommand.call(this, command, args);
  if (command.toUpperCase() === 'HUKI') {
    const setHukidashi = (fid, fse, fvo = 100, fpi = 100) => {
      if ($gameSwitches.value(23) === true) {
        AudioManager.playSe({ "name": fse, "volume": fvo, "pitch": fpi, "pan": 0 });
      }
      this.character(args[0]).requestBalloon(fid);
    };
    switch (args[1]) {
      case "1": case "BIKKURI": return setHukidashi(1, "OtoLogic_huki_bikkuri");
      case "2": case "HATENA": return setHukidashi(2, "OtoLogic_huki_hatena");
      case "3": case "ONPU": return setHukidashi(3, "Saint5", 90, 150);
      case "4": case "HEART": return setHukidashi(4, "Raise2", 90, 150);
      case "5": case "IKARI": return setHukidashi(5, "Thunder2", 70, 90);
      case "6": case "ASE": return setHukidashi(6, "OtoLogic_huki_ase", 70, 90);
      case "7": case "MOYA": return setHukidashi(7, "OtoLogic_huki_moya", 90);
      case "8": case "TINMOKU": return setHukidashi(8, "OtoLogic_huki_tinmoku", 90);
      case "9": case "HIRAMEKI": return setHukidashi(9, "OtoLogic_huki_hirameki", 90);
      case "10": case "ZZZ": return setHukidashi(10, "Sleep", 90);
      case "11": case "COIN": return setHukidashi(11, "Shop2", 100, 85);
      case "12": case "KIDUKU": return setHukidashi(12, "OtoLogic_huki_kiduku", 90);
      case "13": case "WAIWAI": return setHukidashi(13, "OtoLogic_huki_waiwai", 90);
      case "14": case "PUNPUN": return setHukidashi(14, "Thunder3", 90, 110);
      case "15": case "ASE2": return setHukidashi(15, "OtoLogic_huki_ase2", 90);
      case "16": case "PIYO": return setHukidashi(16, "OtoLogic_huki_piyo");
      case "17": case "HONOO": return setHukidashi(17, "OtoLogic_huki_honoo");
      case "18": case "EGAO": return setHukidashi(18, "Onjin_huki_egao");
      case "19": case "TERE": return setHukidashi(19, "OtoLogic_huki_tere");
      case "20": case "AOZAME": return setHukidashi(20, "Onjin_huki_aozame");
    }
  }
};

// イベントエディタでテストするときのエラー対策
Game_Map.prototype.setupForeground = function () {
  if ($dataMap.meta === undefined) $dataMap.meta = {}; // 追加
  this._foregroundName = $dataMap.meta.fgName || '';
  this._foregroundZero = ImageManager.isZeroForeground(this._foregroundName);
  this._foregroundLoopX = !!$dataMap.meta.fgLoopX;
  this._foregroundLoopY = !!$dataMap.meta.fgLoopY;
  this._foregroundSx = Number($dataMap.meta.fgSx) || 0;
  this._foregroundSy = Number($dataMap.meta.fgSy) || 0;
  this._foregroundX = 0;
  this._foregroundY = 0;
};

// 【クラス】ゲームピクチャ拡張
// //////////////////////////////////////////////////////////////////////////////////
const _game_picture = {
  initialize: Game_Picture.prototype.initialize,
  update: Game_Picture.prototype.update,
  initBasic: Game_Picture.prototype.initBasic,
};

// 初期化関数
Game_Picture.prototype.initialize = function () {
  _game_picture.initialize.call(this);
  this.initAnimation();
};

// アニメーション初期値追加
Game_Picture.prototype.initAnimation = function () {
  _game_picture.initialize.call(this);
  this._keyFrames = [];
  this._keyPosition = 0;
  this._keyDuration = 0;
  this._filters = [];
  this._targetFilters = null;
};

// アップデート関数
Game_Picture.prototype.update = function () {
  this.updateAnimation();
  this.updateFilter.call(this);
  _game_picture.update.call(this);
}

// アップデート：アニメーション
Game_Picture.prototype.updateAnimation = function () {
  if (this._keyFrames === undefined) this._keyFrames = [];
  if (this._keyFrames.length <= 0) return;
  if (this._keyDuration <= 0) {
    // 次のキーフレームが存在しない場合はクリア
    if (this._keyPosition >= this._keyFrames.length){
      this._keyPosition = 0;
      this._keyFrames = [];
      return;
    }
    //
    const vprm = {};
    const vset = this._keyFrames[this._keyPosition];
    Object.keys(vset).forEach((vi) => vprm[vi] = vset[vi]);
    // 省略コマンド各種処理
    if (vprm.d !== undefined) vprm.duration = vprm.d;
    if (vprm._keyDuration === undefined) vprm.keyDuration = vprm.duration;
    //
    const setPrm = (vtg, vsub, vkey = null) => {
      if (vkey === null) return;
      if (vprm[vkey] === undefined) return;
      this[vtg] = vprm[vkey];
      if (vsub === vtg) return;
      if (vprm.keyDuration === 0) this[vsub] = vprm[vkey];
    }
    [ // ターゲット値を入力
      ["_angle", "_angle", "angle"],
      ["_origin", "_origin", "origin"],
      ["_targetX", "_x", "x"],
      ["_targetY", "_y", "y"],
      ["_targetScaleX", "_scaleX", "scaleX", "scale"],
      ["_targetScaleY", "_scaleY", "scaleY", "scale"],
      ["_targetOpacity", "_opacity", "opacity"],
      ["_blendMode", "_blendMode", "blendMode"],
      ["_duration", "_duration", "duration"],
      ["_keyDuration", "_keyDuration", "keyDuration"],
      ["_rotationSpeed", "_rotationSpeed", "rotationSpeed"]
    ].forEach((val) => {
      setPrm(val[0], val[1], val[2]);
      setPrm(val[0], val[1], val[3]);
    });
    //
    this._keyPosition++;
    if (vprm.next !== undefined) { // ラベルジャンプ
      this._keyFrames.forEach((vd, vi) => {
        if (vd.label === vprm.next) this._keyPosition = vi;
      });
    }
    if (vprm.keyDuration === 0) return this.updateAnimation();
  } else {
    this._keyDuration--;
  }
}

Game_Picture.prototype.updateFilter = function () {
  if (this._duration > 0) {
  }
  return;
  if (this._duration > 0) {
    var d = this._duration;
    this._x = (this._x * (d - 1) + this._targetX) / d;
    this._y = (this._y * (d - 1) + this._targetY) / d;
    this._scaleX = (this._scaleX * (d - 1) + this._targetScaleX) / d;
    this._scaleY = (this._scaleY * (d - 1) + this._targetScaleY) / d;
    this._opacity = (this._opacity * (d - 1) + this._targetOpacity) / d;
    this._duration--;
  }
};

Game_Picture.prototype.initBasic = function () {
  _game_picture.initBasic.call(this);
  this._filters = null;
};

Game_Picture.prototype.filters = function () {
  return this._filters;
};

const _sprite_picture = {
  update: Sprite_Picture.prototype.update
};

Sprite_Picture.prototype.update = function () {
  _sprite_picture.update.apply(this, arguments);
  if (this.visible) {
    this.updateFilters();
  }
};

Sprite_Picture.prototype.updateFilters = function () {
  const picture = this.picture();
  this.filters = picture.filters();
}
