/*:
 * @plugindesc モンプチ進行度管理
 * @author 夕多丸
 * 
 * @help
 * ■ プラグインコマンド解説例
 * 
 * -----------------------------------------------------
 * NABE_SET switch file type good bad
 * -----------------------------------------------------
 * 鍋の基本設定を用意
 * =====================================================
 * switch  : 判定スイッチ番号
 * file    : ファイル名
 * type    : 演出タイプ
 * good    : 良アイテムリスト
 * bad     : 悪アイテムリスト
 * =====================================================
 * 
/*:ja
 *
 **/
(function () {
  const parameters = PluginManager.parameters('MonpuchiNabe');
  const se = {
    grap: (parameters['se_grap'] || 'Cursor1'),
    release: (parameters['se_release'] || 'Cursor1'),
    trash: (parameters['se_trash'] || 'Cursor1'),
    end: (parameters['se_end'] || 'Cursor1'),
    reset: (parameters['se_reset'] || 'Cursor1')
  };

  const _pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function (command, args) {
    _pluginCommand.call(this, command, args);
    if (command.toUpperCase() === 'PROGRESS') {
      if (monpuchi.progress !== undefined) return;
      monpuchi.progress = new MonpuchiProgress();
    }
    if (command.toUpperCase() === 'PROGRESS_SET') {
      if (monpuchi.progress === undefined) monpuchi.progress = new MonpuchiProgress();
      monpuchi.progress.setObjective(args[0]);
    }
    if (command.toUpperCase() === 'PROGRESS_SHOW') {
      if (monpuchi.progress === undefined) monpuchi.progress = new MonpuchiProgress();
      monpuchi.progress.setShow();
    }
    if (command.toUpperCase() === 'PROGRESS_DELETE') {
      if (monpuchi.progress === undefined) monpuchi.progress = new MonpuchiProgress();
      monpuchi.progress.deleteObjective();
    }
  };

  const _updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
  Game_Interpreter.prototype.updateWaitMode = function () {
    var waiting = false;
    if (this._waitMode === "nabe") {
      const active = this.nabe.update();
      if (active === false) {
        this.nabe = null;
        this._waitMode = "";
      }
      return active;
    }
    return _updateWaitMode.call(this);
  };
})();

/*
* 進行度表示のデフォルト（スイッチ）
+ 進行度変数（章、ステップ）
*/
class MonpuchiProgress {
  constructor() {
    this.ids = this.getIds();
    this.count = 0;
    // 初期値を取得
    this.objective = $gameVariables.value(this.ids.objective);
    //
    this.switchs = {
      active: 241,
      animation: 24
    };
    this.status = {
      starLast: $gameVariables.value(101),
      cardLast: $gameVariables.value(102),
    };
    this.isActive = true;
    //
    // 進行度
    this.prog = this.getProgress();
  }

  getIds() {
    return {
      objective: 7, // 目的
      aniPicId: 8, // アニメーション画像ID
      aniActive: 25 // アニメーション有効
    }
  }

  setObjective(text) {
    $gameVariables.setValue(this.ids.objective, text);
    this.objective = text;
    // console.log($gameVariables.value(7));
  }

  deleteObjective() {
    $gameVariables.setValue(this.ids.objective, " ");
    this.objective = " ";
    // console.log($gameVariables.value(7));
  }


  setShow() {
    // 進行度表示スイッチをON
    $gameSwitches.setValue(this.switchs.active, true);
    // 星の数が変更したかを確認
    const star = $gameVariables.value(101);
    this.showStars(star);
    if (star !== this.status.starLast) {
      $gameSwitches.setValue(25, true);
      $gameVariables.setValue(8, 60 + $gameVariables.value(101) - 1);
      this.status.starLast = star;
    }
    //
    const card = Torigoya.Achievement2.Manager.getUnlockedCount();
    this.showCards(card);
    if (card !== this.status.cardLast) {
      $gameSwitches.setValue(25, true);
      $gameVariables.setValue(8, 65 + card - 1);
      $gameVariables.setValue(102, card);
      this.status.cardLast = card;
    }
    //
    // 目的表示
    // console.log($gameVariables.value(7));
    if ($gameVariables.value(7) !== "") {
      // console.log("show");
      $gameMap._interpreter.pluginCommand("D_TEXT_SETTING", ["BG_COLOR", "Black"]);
      $gameMap._interpreter.pluginCommand("D_TEXT_SETTING", ["BG_GRADATION_RIGHT", "100"]);
      $gameMap._interpreter.pluginCommand("D_TEXT", ["", $gameVariables.value(7), 26]);
      $gameScreen.showPicture(80, "", 0, -200, 10, 100, 100, 0, 0);
      $gameScreen.movePicture(80, 0, 10, 10, 100, 100, 255, 0, 30);
    } else {
      // console.log("erase");
      $gameScreen.erasePicture(80);
    };
    //
    $gameVariables.setValue(102, Torigoya.Achievement2.Manager.getUnlockedCount());
    return false;
  }

  setHide() {
    this.count++;
    switch (this.count) {
      case 1:
        $gameSwitches.setValue(this.switchs.active, false);
        $gameScreen.movePicture(80, 0, 10, 10, 100, 100, 0, 0, 30);
        for (let i = 0; i < 10; i++) {
          const vpic = $gameScreen.picture(60 + i);
          if (vpic !== undefined && vpic !== null) {
            const vsx = vpic.scaleX();
            const vsy = vpic.scaleY();
            $gameScreen.movePicture(60 + i, 1, vpic.x(), vpic.y(), vsx, vsy, 0, 0, 30)
          }
        }
        $gameMap._interpreter.wait(40);
        return true;
      case 2:
        $gameScreen.erasePicture(80);
        for (let i = 0; i < 10; i++) {
          $gameScreen.erasePicture(60 + i);
        }
        this.count = 0;
        return false;
    }
  }

  setAnimation() {
    const isActive = $gameSwitches.value(this.ids.aniActive);
    if (isActive === false) return false;
    //
    const vid = $gameVariables.value(this.ids.aniPicId);
    const vpic = $gameScreen.picture(vid);
    if (vpic === undefined || vpic === null) {
      $gameSwitches.setValue(this.ids.aniActive, false);
      this.count = 0;
      return false;
    }
    //
    this.count++;
    const vx = vpic.x();
    const vy = vpic.y();
    switch (this.count) {
      case 1:
        $gameScreen.movePicture(vid, 1, vx, vy, 250, 250, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 2:
        $gameScreen.movePicture(vid, 1, vx, vy, 200, 200, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 3:
        $gameScreen.movePicture(vid, 1, vx, vy, 1, 200, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 4:
        $gameScreen.movePicture(vid, 1, vx, vy, 200, 200, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 5:
        $gameScreen.movePicture(vid, 1, vx, vy, 1, 150, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 6:
        $gameScreen.movePicture(vid, 1, vx, vy, 150, 150, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 7:
        $gameScreen.movePicture(vid, 1, vx, vy, 1, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 8:
        $gameScreen.movePicture(vid, 1, vx, vy, 100, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 9:
        $gameScreen.movePicture(vid, 1, vx, vy, 1, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 10:
        $gameScreen.movePicture(vid, 1, vx, vy, 100, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 11:
        $gameScreen.movePicture(vid, 1, vx, vy, 1, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        return true;
      case 12:
        $gameScreen.movePicture(vid, 1, vx, vy, 100, 100, 255, 0, 10);
        $gameMap._interpreter.wait(10);
        $gameSwitches.setValue(this.ids.aniActive, false);
        this.count = 0;
        return false;
    }
  }

  // 星を描画する
  showStars(star) {
    for (var i = 0; i < 5; i++) {
      const vs = (star > i) ? 1 : 2;
      const vf = "taiken_shinkou_star" + vs;
      const vx = 626 + (36 * i) + 18;
      const vy = 10 + 18;
      const vp = 60 + i;
      $gameScreen.showPicture(vp, vf, 1, vx, vy, 100, 100, 255, 0)
    }
  }

  showCards(card) {
    for (var i = 0; i < 3; i++) {
      const vs = (card > i) ? 1 : 2;
      const vf = "taiken_shinkou_card" + vs;
      const vx = 698 + (36 * i) + 18;
      const vy = 46 + 18;
      const vp = 65 + i;
      $gameScreen.showPicture(vp, vf, 1, vx, vy, 100, 100, 255, 0)
    }
  }

  getProgress() {
    return {
      id: 0,
      clear: 10,
      data: [
        [50, "\I[22]\C[27]下水道\C[0]を脱出しよう"],
        [51, "\I[22]\C[27]パス\C[0]を手に入れよう"],
        [52, "\I[22]\C[27]脳みそ\C[0]を探そう"],
        [53, "\>\{\{\C[27]倉庫\C[0]に侵入しよう"],
        [54, "\I[22]\C[27]脳みそ\C[0]を取り戻そう"]
      ]
    };
  }
}


