/*:
 * @plugindesc キャラ画像にぼかし(アンチエイリアス)を使えるようにします
 * @author hara
 *
 * @param 適用範囲
 * @desc アンチエイリアスを適用するキャラクター素材画像の条件を指定します。
 * @type select
 * @option すべてのファイル
 * @value 1
 * @option 指定文字を含むファイル
 * @value 2
 * @default 1
 *
 * @param 指定文字
 * @desc 例、指定文字「_sm」
 * 　　アンチエイリアスが適用されるファイル名「neko_sm.png」
 * @default _sm
 * @type string
 *
 * @help
 * キャラクター画像にぼかし(アンチエイリアス)を使えるようにします。
 * このプラグインではキャラ画像ファイルすべてをぼかす設定と、
 * キャラ画像ファイル単位でぼかす設定が可能です。
 *
 * アンチエイリアスとは
 * 　画像を拡大縮小したり回転させたりすると発生する
 * 　ギャリギャリをうまくぼかして目立たなくしてくれます。
 * 　(拡大縮小回転をしない場合は表示に影響はありません)
 *
 * キャラの近くになにかが表示される
 * 　ぼかし設定をしたキャラの近くにうっすらと線などが表示される場合は
 * 　キャラ素材に１ドットの余白をとるように調整してみてください。
 *
 * ・利用規約
 * 禁止事項はありません。
 */

(function() {
'use strict';

var pluginName = 'hr_CharacterSmooth';
var parameters = PluginManager.parameters(pluginName);

var FilenameRng = Number(parameters['適用範囲']);
var FilenameKey = String(parameters['指定文字']);

ImageManager.loadCharacter = function(filename, hue) {
    var smooth = false;
    if (FilenameRng == 2) {
        if (filename.includes(FilenameKey)) smooth = true;
    } else {
        smooth = true;
    }
    return this.loadBitmap('img/characters/', filename, hue, smooth);
};

})();